-- MiG-29MU2 by Currenthill
------------------------------------------------------

MiG_29MU2 =  {
	
	Name 				=   'CH_MiG-29MU2',
	DisplayName			= _('[CH] MiG-29MU2'),
	Picture 			= "mig-29.png",
	Rate 				= 50, -- RewardPoint in Multiplayer
	Shape 				= "mig-29mu2",

	shape_table_data 	= 
	{
		{
			file  	 	= 'mig-29mu2';
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'mig-29-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'MiG-29MU2';
			index    	=  WSTYPE_PLACEHOLDER;
            classname   = 'lLandPlane',
            positioning = 'BYNORMAL',
		},
		{
			name  = "mig-29-oblomok";
			file  = "mig-29-oblomok";
			fire  = { 240, 2};
		},

	},

	effects_presets = {
		{effect = "OVERWING_VAPOR", preset = "MiG29"},
		
	},
		
    mapclasskey 	= "P0091000024",
    WorldID         = WSTYPE_PLACEHOLDER,	
	Countries 		= {"Ukraine"},
	attribute 		= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", },
	Categories		= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	

    ColdStartDefaultControls = {
    [274] = 1.0,
	[275] = 1.0,
	},

-- ==============================================================================================================
		
	M_empty 					= 11222, --11300 - unusable fuel 78kg 
	M_nominal					= 13240,
	M_max						= 19700,
	M_fuel_max					= 3493, --4450*0.785
	H_max						= 18000,
	average_fuel_consumption	= 0.2743,
	CAS_min						= 60,
	V_opt						= 222,
	V_take_off					= 67,
	V_land						= 70,
	AOA_take_off				= 0.17,
	stores_number				= 7,
	bank_angle_max				= 60,
	Ny_min						= -3,
	Ny_max						= 8,
	V_max_sea_level				= 416.7,
	V_max_h						= 680.6,
	Vy_max						= 330,
	Mach_max					= 2.3,
	Ny_max_e					= 8,
	has_afteburner				= true,
	has_speedbrake				= true,
	bigParkingRamp 				= false,		
    undercarriage_movement 		= 2,		

-- ==============================================================================================================
		
	tand_gear_max	=	0.577,
	nose_gear_pos = 	{2.917,	-1.644,	0},
	nose_gear_wheel_diameter	=	0.57,
	main_gear_wheel_diameter	=	0.84,
	main_gear_pos = 	{-0.68,	-1.525,	1.55},		
		
-- ==============================================================================================================

	brakeshute_name	=	4,
	
	wing_tip_pos = 	{-3.8,	0.14,	5.8},
	wing_area	=	38.1,
	wing_span	=	11.36,
	flaps_maneuver	=	1,

	thrust_sum_max	=	10160,
	thrust_sum_ab	=	16680,

	length	=	20.32,
	height	=	4.73,
	range	=	1500,
	RCS	=	5,
	IR_emission_coeff	=	0.77,
	IR_emission_coeff_ab	=	4,

	engines_count	=	2,
	engines_nozzles = 
	{
		[1] = 
		{
			pos = 	{-5.534,	-0.063,	-0.909},
			elevation	=	-1.5,
			diameter	=	0.949,
			exhaust_length_ab	=	8.629,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.5,
			azimuth      = 2.5,
		}, -- end of [1]
		[2] = 
		{
			pos = 	{-5.534,	-0.063,	0.909},
			elevation	=	-1.5,
			diameter	=	0.949,
			exhaust_length_ab	=	8.629,
			exhaust_length_ab_K	=	0.76,
			smokiness_level     = 	0.5,
			azimuth      = -2.5,
		}, -- end of [2]
	}, -- end of engines_nozzles

-- ==============================================================================================================

	crew_members = { {
			drop_canopy_name = 47,
			ejection_seat_name = 9,
			pos = { 4.403, 1.209, 0 },
			role = "pilot",
			role_display_name = "Pilot"
		} },

-- ==============================================================================================================

	mechanimations = {
            Door0 = {
                {Transition = {"Close", "Open"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 0.6, "sign" , 2}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 1.0, "sign" , 2}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 0.3, "sign" , 2}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 1.0, "sign" , 2}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                    }, Flags = {"Reversible"}},
                {Transition = {"Open", "Close"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.00 * 0.9, "at", 0.6}}},
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 1.0, "sign" , -2}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 0.3, "sign" , -2}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 1.0, "sign" , -2}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 0.5, "sign" , -2}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.25, "sign" , -2}}},
                        {C = {{"Arg", 38, "to", 0.95 * 0.9, "at", 0.125, "sign" , -2}}},
                    }, Flags = {"Reversible", "StepsBackwards"}},
                {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0}}}}},
            },	
			
			HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0.5 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 1 } }
					} },
				Transition = { "Any", "High" }
			} },

		LeftStrut = {        
				{
					Transition = {"Retract", "Extend"},                  
					Sequence = {						
						{C = {{"Arg",  5, "to", 1.0, "in", 4.0, "sign", 1}}},   
						{C = {{"Arg", 93, "to", 1.0, "in", 4.0, "sign", 1}}},  
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"},                     
					Sequence = {
						{C = {{"Arg", 93, "to", 0.0, "in", 4.0, "sign", -1}}}, 
						{C = {{"Arg",  5, "to", 0.0, "in", 4.0, "sign", -1}}},  						
					},
					Flags = {"Reversible"},
				},
				}, 
			RightStrut = {
				{
					Transition = {"Retract", "Extend"},
					Sequence = {				
						{C = {{"Arg",  3, "to", 1.0, "in", 4.0, "sign", 1}}},  
						{C = {{"Arg", 94, "to", 1.0, "in", 4.0, "sign", 1}}},
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"},
					Sequence = {
						{C = {{"Arg", 94, "to", 0.0, "in", 4.0, "sign", -1}}},						
						{C = {{"Arg",  3, "to", 0.0, "in", 4.0, "sign", -1}}},  
					},
					Flags = {"Reversible"},
				},
			},
			CentralStrut = {
				{
					Transition = {"Retract", "Extend"},
					Sequence = {				
						{C = {{"Arg", 0, "to",  1.0, "in", 4.0, "sign", 1}}},   
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"}, 
					Sequence = {						
						{C = {{"Arg", 0, "to", 0.0 , "in", 4.0, "sign", -1}}}, 			
					},
					Flags = {"Reversible"},
				},
			},				
	},

-- ==============================================================================================================

	Guns = {gun_mount("GSh_30_1", { count = 100 },
			{muzzle_pos_connector = "Gun_point", elevation_initial = 0, 
			drop_cartridge = 0; ejector_dir = {-2 ,-5, 0}, supply_position = { 0, 0, 0 },
			effects = { {arg = 350, attenuation = 2, duration = 0.02, light_pos = { 0.5, 0, 0 }, 
			name = "FireEffect"}, {name = "SmokeEffect"} },}),
	},

-- ==============================================================================================================

	-- Countermeasures, 
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 60,
		-- PPR-26
		chaff = {default = 30, increment = 30, chargeSz = 1},
		-- PPI-26
		flare = {default = 30, increment = 30, chargeSz = 1}
	},
	
	chaff_flare_dispenser = 
	{
		[1] = 
		{
			dir = 	{0,	0.999,	0.052},
			pos = 	{-0.937,	1.645,	-1.726},
		}, -- end of [1]
		[2] = 
		{
			dir = 	{0,	0.999,	-0.052},
			pos = 	{-0.937,	1.645,	1.726},
		}, -- end of [2]
	}, -- end of chaff_flare_dispenser	

	Countermeasures = {
		ECM = "Gardenia"
	},

	Sensors = {
		RADAR = "MiG-29MU2 N-019-U1",
		IRST = "KOLS",
		RWR = "Abstract RWR",
		OPTIC = "Kaira-1",
	},
	
	laserEquipment = { 
		laserDesignator = true,
		laserRangefinder = true
	},

	detection_range_max		= 250,
	radar_can_see_ground	= true,
	EPLRS                 	= true,

    CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),

-- ==============================================================================================================

	Pylons =     {
		 pylon(1, 0, -1.972119, -0.160566, -3.470583,
            {
				arg 	  = 308,
				arg_value = 0,
                connector = "Pylon1",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L						
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M							
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B	
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C	
					{ CLSID = "<CLEAN>", arg_value = 1 },						
            }
        ),
				
		 pylon(2, 0, -1.972119, -0.160566, -3.470583,
            {
				arg 	  = 309,
				arg_value = 0,
                connector = "Pylon2",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L						
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M						
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C					
					{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.0 },--Kh-29T		
					{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3 },--KAB-500Kr
					{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
					{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.3, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
					{ CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", arg_value = 0.3 },-- UB-32A - 32 S-5KO
					{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3 },-- B-8M1 - 20 S-8KOM
					{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3 },-- B-13L - 5 S-13 OF
					{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.0 },-- S-25 OFM
					{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3 },-- B-8M1 - 20 S-8TsM	
					{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C	
					{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.0 },-- Kh-25ML	
					{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3 },-- FAB-500 M62		
					{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3 },-- FAB-250			
					{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.0 },-- S-24B						
					{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", arg_value = 0.3 },-- Zuni	
					{ CLSID = "<CLEAN>", arg_value = 1 },						
					{ CLSID = "{CH_AASM250}", arg_value = 0.3, Type = 1 },-- AASM 250					
					
            }
        ),

        pylon(3, 0, -1.972119, -0.160566, -3.470583,
            {
				arg 	  = 310,
				arg_value = 0,
                connector = "Pylon3",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{C0FF4842-FBAC-11d5-9190-00A0249B6F00}", arg_value = 0.1 },--PTB-1150						
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L		
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M						
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B	
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C						
					{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.7 },--Kh-29T		
					{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3 },--KAB-500Kr	
					{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.7, Type = 1 },--ADM-160B	
					{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.3, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
					{ CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", arg_value = 0.3 },-- UB-32A - 32 S-5KO
					{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3 },-- B-8M1 - 20 S-8KOM
					{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.7 },-- S-25 OFM
					{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3 },-- B-8M1 - 20 S-8TsM	
					{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.7 },-- AGM-88C
					{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.7 },-- Kh-25ML		
					{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3 },-- FAB-500 M62		
					{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3 },-- FAB-250			
					{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.7 },-- S-24B	
					{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", arg_value = 0.3 },-- Zuni	
					{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.7 },--ADM-160B x3	
					{ CLSID = "<CLEAN>", arg_value = 1 },			
					{ CLSID = "{CH_AASM250}", arg_value = 0.3, Type = 1 },-- AASM 250						
				
            }
        ),      
        pylon(4, 1, 0.156954, -0.131732, -0.0043283,
            {
				connector = "Point Zero 04",use_full_connector_position=false,
            },
            {
					{ CLSID = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}" },--PTB-1400				

            }
        ),
        pylon(5, 1, -2.400118, -0.945056, 0.472034,
            {
				arg 	  = 312,
				arg_value = 0,
                connector = "Pylon5",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{C0FF4842-FBAC-11d5-9190-00A0249B6F00}", arg_value = 0.1 },--PTB-1150						
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L		
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M						
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B	
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C						
					{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.7 },--Kh-29T		
					{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3 },--KAB-500Kr	
					{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.7, Type = 1 },--ADM-160B	
					{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.3, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
					{ CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", arg_value = 0.3 },-- UB-32A - 32 S-5KO
					{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3 },-- B-8M1 - 20 S-8KOM
					{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.7 },-- S-25 OFM
					{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3 },-- B-8M1 - 20 S-8TsM	
					{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.7 },-- AGM-88C
					{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.7 },-- Kh-25ML		
					{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3 },-- FAB-500 M62		
					{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3 },-- FAB-250			
					{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.7 },-- S-24B	
					{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", arg_value = 0.3 },-- Zuni	
					{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.7 },--ADM-160B x3	
					{ CLSID = "<CLEAN>", arg_value = 1 },	
					{ CLSID = "{CH_AASM250}", arg_value = 0.3, Type = 1 },-- AASM 250						
				
            }
        ),
        pylon(6, 1, 1.966954, -0.751732, 0.472034,
            {
				arg 	  = 313,
				arg_value = 0,
                connector = "Pylon6",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L			
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M						
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C					
					{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.0 },--Kh-29T		
					{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3 },--KAB-500Kr
					{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
					{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.3, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
					{ CLSID = "{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", arg_value = 0.3 },-- UB-32A - 32 S-5KO
					{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3 },-- B-8M1 - 20 S-8KOM
					{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3 },-- B-13L - 5 S-13 OF
					{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.0 },-- S-25 OFM
					{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3 },-- B-8M1 - 20 S-8TsM	
					{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C	
					{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.0 },-- Kh-25ML	
					{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3 },-- FAB-500 M62		
					{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3 },-- FAB-250			
					{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.0 },-- S-24B						
					{ CLSID = "{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", arg_value = 0.3 },-- Zuni	
					{ CLSID = "<CLEAN>", arg_value = 1 },	
					{ CLSID = "{CH_AASM250}", arg_value = 0.3, Type = 1 },-- AASM 250						

            }
        ),
		pylon(7, 1, 1.966954, -0.751732, 0.472034,
            {
				arg 	  = 314,
				arg_value = 0,
                connector = "Pylon7",
				use_full_connector_position = true,
            },
            {
					{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
					{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M					
					{ CLSID = "{AIM-9L}" },--AIM-9L		
					{ CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },--AIM-9M						
					{ CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", arg_value = 0.2 },--R-27ER
					{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", arg_value = 0.2 },--R-27ET
					{ CLSID = "{C8E06185-7CD6-4C90-959F-044679E90751}", arg_value = 0.2 },--AIM-120B	
					{ CLSID = "{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", arg_value = 0.2 },--AIM-120C	
					{ CLSID = "<CLEAN>", arg_value = 1 },						

            }
        ),

	},
	
	Tasks = {
        aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(CAP),

-- ==============================================================================================================

	SFM_Data = {
		aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.032,
			cx_flap	=	0.035,
			cy_flap	=	0.24,
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.024,	0.07,	0.075,	0.12,	0.5,	30,	1.2},
				[2] = 	{0.2,	0.024,	0.07,	0.075,	0.12,	1.5,	30,	1.2},
				[3] = 	{0.4,	0.024,	0.07,	0.075,	0.12,	2.5,	30,	1.2},
				[4] = 	{0.6,	0.0239,	0.073,	0.075,	0.12,	3.5,	30,	1.2},
				[5] = 	{0.7,	0.024,	0.076,	0.075,	0.12,	3.5,	28.666666666667,	1.18},
				[6] = 	{0.8,	0.0235,	0.079,	0.075,	0.12,	3.5,	27.333333333333,	1.16},
				[7] = 	{0.9,	0.025,	0.083,	0.075,	0.125,	3.5,	26,	1.14},
				[8] = 	{1,	0.044,	0.085,	0.14,	0.1,	3.5,	24.666666666667,	1.12},
				[9] = 	{1.05,	0.0465,	0.0855,	0.1775,	0.125,	3.5,	24,	1.11},
				[10] = 	{1.1,	0.049,	0.086,	0.215,	0.15,	3.15,	18,	1.1},
				[11] = 	{1.2,	0.049,	0.083,	0.228,	0.17,	2.45,	17,	1.05},
				[12] = 	{1.3,	0.049,	0.077,	0.237,	0.2,	1.75,	16,	1},
				[13] = 	{1.5,	0.0475,	0.062,	0.251,	0.2,	1.5,	13,	0.9},
				[14] = 	{1.7,	0.045166666666667,	0.051333333333333,	0.24366666666667,	0.32,	0.9,	12,	0.7},
				[15] = 	{1.8,	0.044,	0.046,	0.24,	0.38,	0.86,	11.4,	0.64},
				[16] = 	{2,	0.043,	0.039,	0.222,	2.5,	0.78,	10.2,	0.52},
				[17] = 	{2.2,	0.041,	0.034,	0.227,	3.2,	0.7,	9,	0.4},
				[18] = 	{2.5,	0.04,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
				[19] = 	{3.9,	0.035,	0.033,	0.35,	6,	0.7,	9,	0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg		=	71,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	6600,
			dpdh_f	=	13200,
			table_data = 
			{
				[1] = 	{0,	88000,	141000},
				[2] = 	{0.2,	80000,	143000},
				[3] = 	{0.4,	79000,	150000},
				[4] = 	{0.6,	82000,	165000},
				[5] = 	{0.7,	90000,	177000},
				[6] = 	{0.8,	94000,	193000},
				[7] = 	{0.9,	96000,	200000},
				[8] = 	{1,	100000,	205000},
				[9] = 	{1.1,	100000,	214000},
				[10] = 	{1.2,	98000,	222000},
				[11] = 	{1.3,	100000,	235000},
				[12] = 	{1.5,	98000,	258000},
				[13] = 	{1.8,	94000,	276000},
				[14] = 	{2,	88000,	283000},
				[15] = 	{2.2,	82000,	285000},
				[16] = 	{2.5,	80000,	287000},
				[17] = 	{3.9,	50000,	200000},
			}, -- end of table_data
		}, -- end of engine
	},

-- ==============================================================================================================

	fires_pos = { { -1.36, -0.185, 0 }, { -0.795, 0.294, 2.46 }, { -0.843, 0.234, -2.769 }, { -1.82, 0.265, 3.974 }, { -1.82, 0.265, -4.274 },
		[8] = { -4.471, -0.059, 0.91 },
		[9] = { -4.471, -0.059, -0.91 },
		[10] = { -0.491, 0.629, 2.03 },
		[11] = { -0.491, -0.019, 0 }
	},

	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = { {
			args = { 296 },
			critical_damage = 3
		}, {
			args = { 297 },
			critical_damage = 3
		}, {
			args = { 65 },
			critical_damage = 8
		}, {
			args = { 298 },
			critical_damage = 2
		}, {
			args = { 301 },
			critical_damage = 2
		},
		[0] = {
			args = { 146 },
			critical_damage = 5
		},
		[8] = {
			args = { 265 },
			critical_damage = 2
		},
		[9] = {
			args = { 154 },
			critical_damage = 3
		},
		[10] = {
			args = { 153 },
			critical_damage = 3
		},
		[11] = {
			args = { 167 },
			critical_damage = 1
		},
		[12] = {
			args = { 161 },
			critical_damage = 1
		},
		[13] = {
			args = { 169 },
			critical_damage = 2
		},
		[14] = {
			args = { 163 },
			critical_damage = 2
		},
		[15] = {
			args = { 267 },
			critical_damage = 2
		},
		[16] = {
			args = { 266 },
			critical_damage = 2
		},
		[17] = {
			args = { 168 },
			critical_damage = 2
		},
		[18] = {
			args = { 162 },
			critical_damage = 2
		},
		[19] = {
			args = { 183 },
			critical_damage = 1
		},
		[20] = {
			args = { 185 },
			critical_damage = 1
		},
		[21] = {
			args = { 230 },
			critical_damage = 2
		},
		[22] = {
			args = { 220 },
			critical_damage = 2
		},
		[23] = {
			args = { 223 },
			critical_damage = 5
		},
		[24] = {
			args = { 213 },
			critical_damage = 5
		},
		[25] = {
			args = { 226 },
			critical_damage = 2
		},
		[26] = {
			args = { 216 },
			critical_damage = 2
		},
		[29] = {
			args = { 224 },
			critical_damage = 6,
			deps_cells = { 21, 23, 25 }
		},
		[30] = {
			args = { 214 },
			critical_damage = 6,
			deps_cells = { 22, 24, 26 }
		},
		[33] = {
			args = { 231 },
			critical_damage = 2
		},
		[34] = {
			args = { 221 },
			critical_damage = 2
		},
		[35] = {
			args = { 225 },
			critical_damage = 6,
			deps_cells = { 21, 23, 25, 29, 33, 37 }
		},
		[36] = {
			args = { 215 },
			critical_damage = 6,
			deps_cells = { 22, 24, 26, 30, 34, 38 }
		},
		[37] = {
			args = { 228 },
			critical_damage = 2
		},
		[38] = {
			args = { 218 },
			critical_damage = 2
		},
		[39] = {
			args = { 244 },
			critical_damage = 2
		},
		[40] = {
			args = { 241 },
			critical_damage = 2
		},
		[43] = {
			args = { 243 },
			critical_damage = 2,
			deps_cells = { 39, 53 }
		},
		[44] = {
			args = { 242 },
			critical_damage = 2,
			deps_cells = { 40, 54 }
		},
		[51] = {
			args = { 240 },
			critical_damage = 2
		},
		[52] = {
			args = { 238 },
			critical_damage = 2
		},
		[53] = {
			args = { 248 },
			critical_damage = 2
		},
		[54] = {
			args = { 247 },
			critical_damage = 2
		},
		[55] = {
			args = { 159 },
			critical_damage = 2
		},
		[58] = {
			args = { 156 },
			critical_damage = 2
		},
		[59] = {
			args = { 148 },
			critical_damage = 2
		},
		[82] = {
			args = { 152 },
			critical_damage = 2
		},
		[83] = {
			args = { 134 },
			critical_damage = 3
		},
		[84] = {
			args = { 136 },
			critical_damage = 3
		},
		[85] = {
			args = { 135 },
			critical_damage = 3
		},
		[90] = {
			args = { 663 },
			critical_damage = 1
		}
	},
	
	DamageParts = 
	{  
		[1] = "MIG-29c-OBLOMOK-WING-R", -- wing R
		[2] = "MIG-29c-OBLOMOK-WING-L", -- wing L
	},	

-- ==============================================================================================================

	lights_data = {
		lights = {
			[3] = {
				lights = { {
						argument = 192,
						typename = "argumentlight"
					}, {
						argument = 190,
						typename = "argumentlight"
					}, {
						argument = 191,
						typename = "argumentlight"						
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},
}

add_aircraft(MiG_29MU2)
